;;
;;  revert.lsp - REVERT command
;;
;;  Copyright  1999 by Autodesk, Inc.
;;
;;  Your use of this software is governed by the terms and conditions
;;  of the License Agreement you accepted prior to installation of this
;;  software.  Please note that pursuant to the License Agreement for this
;;  software, "[c]opying of this computer program or its documentation
;;  except as permitted by this License is copyright infringement under
;;  the laws of your country.  If you copy this computer program without
;;  permission of Autodesk, you are violating the law."
;;
;;  AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;  AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;  MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;  DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;  UNINTERRUPTED OR ERROR FREE.
;;
;;  Use, duplication, or disclosure by the U.S. Government is subject to
;;  restrictions set forth in FAR 52.227-19 (Commercial Computer
;;  Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
;;  (Rights in Technical Data and Computer Software), as applicable.
;;  
;;-------------------------------------------------------------------------
;;
;;  DESCRIPTION
;;    Implements the REVERT command.
;;
;;-------------------------------------------------------------------------
 
 
;;
;;  revert to previous saved version of this drawing
;;
(defun C:REVERT (/ dwg reply sdiOpen)
  ;;  special open for SDI mode
  (defun sdiOpen (name force)
    (vl-load-com)
    (vla-sendcommand
        (vla-get-activedocument
            (vlax-get-acad-object))
                (acet-str-format "(command \"_.OPEN\"%1)\n%2\n"
                                 (if force " \"_Y\"" "")
                                 name ) )
  )
 
  ;;  quiet
  (acet-error-init '(("CMDECHO" 0)))
  ;;  check for the necessary support code
  (if (acet-reg-get (strcat "HKEY_LOCAL_MACHINE\\"
                            (acet-reg-machine-prodkey)
                            "\\Applications\\acadvba\\commands" )
                    "VBASTMT" )
    ;;  worth trying ??
    (if (= 1 (getvar "DWGTITLED"))
      (progn
        ;;  pick file name
        (setq dwg (strcat (getvar "DWGPREFIX") (getvar "DWGNAME")))
        ;;  drawing modified ??
        (if (and (/= 0 (getvar "DBMOD"))
                 (= Acet:IDCANCEL
                    (acet-ui-message
                        (acet-str-format "Abandon changes to %1?" dwg)
                                         "AutoCAD - REVERT"
                                         (+ Acet:OKCANCEL
                                            Acet:ICONWARNING
                                            Acet:DEFBUTTON2 ) ) ) )
          (exit)
        )
        ;; SDI ??
        (if (/= 0 (getvar "SDI"))
          (sdiOpen dwg (/= 0 (getvar "DBMOD")))
          (command "_vbastmt" (acet-str-format
              "ThisDrawing.Close(FALSE):AcadApplication.Documents.Open \"%1\""
              dwg ) )
        )
      )
      (acet-ui-message "Drawing has never been saved."
                       "AutoCAD - REVERT"
                       Acet:ICONSTOP )
    )
    (acet-ui-message "VBA support not installed."
                     "AutoCAD - REVERT"
                     Acet:ICONSTOP )
  )
 
  (acet-error-restore)
  (princ)
)


(princ)
;;;-----BEGIN-SIGNATURE-----
;;; aAcAADCCB2QGCSqGSIb3DQEHAqCCB1UwggdRAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIFBjCCBQIwggPqoAMCAQICEGS8scfO5NpYadWPHiL76fQw
;;; DQYJKoZIhvcNAQELBQAwfzELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVj
;;; IENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTAw
;;; LgYDVQQDEydTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0Ew
;;; HhcNMTUwOTAzMDAwMDAwWhcNMTYwOTAyMjM1OTU5WjCBiDELMAkGA1UEBhMCVVMx
;;; EzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwxFjAUBgNV
;;; BAoMDUF1dG9kZXNrLCBJbmMxHzAdBgNVBAsMFkRlc2lnbiBTb2x1dGlvbnMgR3Jv
;;; dXAxFjAUBgNVBAMMDUF1dG9kZXNrLCBJbmMwggEiMA0GCSqGSIb3DQEBAQUAA4IB
;;; DwAwggEKAoIBAQDqmfToz8wEanfXT+H6tql3aUyaJRWCfFsYPFnGVXIl95fnZY3s
;;; OEfQvFkf9LVte5SwDWkjkReCGJlk4HaRYOTxkd7PkeAOOtYaUSBvULYRlKvAbe2n
;;; +VWwo4yrWATav8d7pKlbMP9f6pYxlaZQzsq/e+pLZwptP8C9Dfrm5OVgCIL/iPRN
;;; Iuvhl9YUZvnkZYmCnihdP4AS8g4d7rfjdxzT653433nO6tgs3fNgnkQQk6EdROwq
;;; esgQXRlH29yRND5xNfup9KiZ7L7Nm7AiM6laNwNIjBwbG4qMWuQ2Ml7hHzQpLaLF
;;; JRV33oHedeGSZ7OmA6+D5WoQtPpSt4YCcub5AgMBAAGjggFuMIIBajAJBgNVHRME
;;; AjAAMA4GA1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBmBgNVHSAE
;;; XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5zeW1j
;;; Yi5jb20vY3BzMCUGCCsGAQUFBwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBh
;;; MB8GA1UdIwQYMBaAFJY7U/B5M5evfYPvLivMyreGHnJmMCsGA1UdHwQkMCIwIKAe
;;; oByGGmh0dHA6Ly9zdi5zeW1jYi5jb20vc3YuY3JsMFcGCCsGAQUFBwEBBEswSTAf
;;; BggrBgEFBQcwAYYTaHR0cDovL3N2LnN5bWNkLmNvbTAmBggrBgEFBQcwAoYaaHR0
;;; cDovL3N2LnN5bWNiLmNvbS9zdi5jcnQwEQYJYIZIAYb4QgEBBAQDAgQQMBYGCisG
;;; AQQBgjcCARsECDAGAQEAAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQAegWHWPJ8y1kt5
;;; 7JP8TOQlnYs0eMMg5/MHxlW3LhKv/PG8jZ2NDg8YrGuwBC7y3um+PA6KxRT9px8N
;;; KjniMX4NsPtQ81s2EITHy4uFfz6dTpgmL2BLE2/6FPmG4koEhY6zeT4tizeTscOR
;;; Mu1gCtr4Vq+BC/+0Ax6LKOGt5Ut1pJT89ivzZYZOIvEtt9AZRgh7GRg2Oz7X6MFn
;;; c3KudMQhCEnBEUkbS3fmC+kll5PuoF/R1XBcbby0ODfQ3xfwSpNd6WIMr2T5HnSC
;;; gOMmAsuP1Y6LjaCoYDP2mhiwMg797o0XVywnKLEeDGw/F9b/c+lpIBuWGWYnFjz7
;;; CTe7cgdcMYICIjCCAh4CAQEwgZMwfzELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
;;; bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3
;;; b3JrMTAwLgYDVQQDEydTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBDb2RlIFNpZ25p
;;; bmcgQ0ECEGS8scfO5NpYadWPHiL76fQwDQYJKoZIhvcNAQELBQAwDQYJKoZIhvcN
;;; AQEBBQAEggEAAD9hdjf7MUUm41FUrLY+RGO8v+I5myFmIzYr5HNLE5S1qOERa80b
;;; MI8HNsQYhSWFE9kIFqQHB6ZFwl6hT5fVKsb5IsV1aUSR7DVYfjrZ5SRvFaYpWgq9
;;; OmKkb5Q67vXegVi3gArj+Gd8lka8Gvjkm4Ln1LqSYjCRmTUAaj+hmlNfNIIqYZdC
;;; V0ZIYHBakFViCx9o1aW66uub9qqkIGfW3UJ0qcb69wPqX4HtYZtNy5hZXCHULDWZ
;;; 9wYjNop0/ciN6ejVB4kYqH2ehcNQesMZYEtH8wyKxLVhq7koTIuTFkFAskJktL6O
;;; WCsS7FfmBW794KL0J1LKfB/Sw5XgDiT2E6FhMF8GA1UdDjFYBFYzADkAOwAyAC8A
;;; NwAvADIAMAAxADYALwA1AC8AOQAvADUANQAvAFQAaQBtAGUAIABmAHIAbwBtACAA
;;; dABoAGkAcwAgAGMAbwBtAHAAdQB0AGUAcgAAAA==
;;; -----END-SIGNATURE-----